 ; Ŀ
 ;   Grak - explode all groups in the current drawing.                     
 ;   Copyright 1999, 2004, 2005 by Rocket Software Ltd.                    
 ;   Can epoxy glue be used to attach tail-lights to an armadillo?         
 ; 

 ; Ŀ
 ;   Subroutine Grak - the blades.                                         
 ;   Takes no arguments, calls nothing.                                    
 ;   Returns the number of groups destroyed.                               
 ;   Feels no remorse.                                                     
 ; 
 (DEFUN GRAK (/ grdict lenstr num count sub grnam)
  (setq grdict (dictsearch (namedobjdict) "acad_group"))
  (setq lenstr (strcat "/" (itoa (length grdict))))
  (setq num 0)
  (setq count 0)
  (while (setq sub (nth num grdict))
         (setq num (1+ num))
         (grtext -2 (strcat (itoa num) lenstr))
         (if (= (car sub) 3)
             (progn
 ; Ŀ
 ;   Extract the Group name.                                               
 ; 
                  (setq grnam (cdr sub))
                  (print grnam)
 ; Ŀ
 ;   And get the Group data.                                               
 ; 
                  (setq namlst (member (cons 3 grnam) grdict))
                  (setq grdat (entget (cdadr namlst)))
 ; Ŀ
 ;   The 70 group in the Group definition supposedly has a value of        
 ;   either 0 = named or 1 = unnamed.                                      
 ;   However, of two groups tested, the one with a value of (70 . 0)       
 ;   could be exploded, the (70 . 3) one couldn't.  Auditing doesn't fix   
 ;   this problem and the group can't be purged.  It has no members.       
 ;   So try to fix it.                                                     
 ; 
                  (if (= (cdr (setq asoc70 (assoc 70 grdat))) 3)
                      (entmod (subst (cons 70 0) asoc70 grdat)))
 ; Ŀ
 ;   Explode the Group.                                                    
 ; 
                  (command ".-group" "explode" grnam)
                  (setq count (1+ count)))))
 count)
 ; Ŀ
 ;   Grak end                                                              
 ; 

 ; Ŀ
 ;   Grak.                                                                 
 ; 
 (DEFUN C:GRAK (/ insp count)
  (setvar "cmdecho" 0)
  (if (/= 4 (logand 4 (getvar "cmdactive")))   ; don't prompt during a script
      (progn
           (initget 0 "Yes No")
           (setq insp (getkword (strcat "Really Explode all Groups? <Y>: ")))))
  (if (or (null insp) (= insp "Yes"))
      (progn
           (setq count (grak))
           (write-line (strcat "Groups exploded: " (itoa count)))))
 (princ))